/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.kawakubo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 *
 * @author tomoharu
 */
public class BasketDAOImpl implements BasketDAO {
    
    private static final String SQL_INSERT_BASKET = "insert into basket values(0, ?)";
    private static final String SQL_DELETE_BASKET = "delete from basket where id = ?"; // 第6回で追加
    private static final String SQL_GET_BASKETID = "select * from basket where user_id = ?";
    private static final String SQL_INSERT_BASKET_ITEM = "insert into basket_item values(0, ?, ?, 1)";
    private static final String SQL_UPDATE_BASKET_ITEM = "update basket_item set quantity = ? where id = ?"; // 第6回で追加
    private static final String SQL_DELETE_BASKET_ITEM = "delete from basket_item where id = ?"; // 第6回で追加
    // 第6回でbasket_itemのidを返すよう変更
    private static final String SQL_GET_ALL_BASKET_ITEMS = "select b.id as basket_item_id, m.id, m.name, m.price, b.meigara_id, b.quantity"
            + " from (basket_item as b inner join meigara as m on b.meigara_id = m.id)"
            + " where basket_id = ?";


    public int getBasketId(String userId) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        int basketId = 0;
        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(SQL_GET_BASKETID);
            preparedStatement.setString(1, userId);
            rs = preparedStatement.executeQuery();
            while(rs.next()) {
                basketId = rs.getInt("id");
            }
        } catch(SQLException se) {
            se.printStackTrace();
            System.out.println(se.getMessage());
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                preparedStatement = null;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                rs = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
        return basketId;
    }

    public void insertBasket(String userId) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(SQL_INSERT_BASKET);
            preparedStatement.setString(1, userId);
            preparedStatement.executeUpdate();
        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                preparedStatement = null;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                rs = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
    }

    public void removeBasket(int basketId) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(SQL_DELETE_BASKET);
            preparedStatement.setInt(1, basketId);
            preparedStatement.executeUpdate();
        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                preparedStatement = null;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                rs = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
    }

    /*
     * 戻り値はカタログから追加しようとするものから、既に買い物かごに
     * 存在するものを除いたものの銘柄のid(String型)の配列
     */
    public ArrayList<String> retrieveItems(int basketId, String[] meigaraItems) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        ArrayList<String> catalogIds = new ArrayList(Arrays.asList(meigaraItems));
        ArrayList<String> insertedIds = new ArrayList<String>();
        ArrayList<String> alreadyExistIds = new ArrayList<String>();
        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(SQL_GET_ALL_BASKET_ITEMS);
            preparedStatement.setInt(1, basketId);
            rs = preparedStatement.executeQuery();
            while(rs.next()) {
                alreadyExistIds.add(String.valueOf(rs.getInt("id")));
            }
            for (int i = 0; i < catalogIds.size(); i++) {
                if (!alreadyExistIds.contains(catalogIds.get(i))) {
                    insertedIds.add(catalogIds.get(i));
                }
            }
        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                preparedStatement = null;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                rs = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
        return insertedIds;
    }

    public void insertItems(int basketId, ArrayList<String> insertedMeigaraIds) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(SQL_INSERT_BASKET_ITEM);

            for (int i = 0; i < insertedMeigaraIds.size(); i++) {
                preparedStatement.setInt(1, basketId);
                preparedStatement.setInt(2, Integer.parseInt(insertedMeigaraIds.get(i)));
                preparedStatement.executeUpdate();
            }

        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                preparedStatement = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
    }

    // 第6回で追加
    public void updateItems(String[] basketItemIds, String[] allQuantity) {
        Connection conn = null;
        PreparedStatement updatePreparedStatement = null;
        PreparedStatement deletePreparedStatement = null;
        ArrayList<String> updatedBasketItemIds = new ArrayList(Arrays.asList(basketItemIds));
        ArrayList<String> updatedAllQuantity = new ArrayList(Arrays.asList(allQuantity));
        try {
            conn = getConnection();
            updatePreparedStatement = conn.prepareStatement(SQL_UPDATE_BASKET_ITEM);
            deletePreparedStatement = conn.prepareStatement(SQL_DELETE_BASKET_ITEM);
            for (int i = 0; i < updatedBasketItemIds.size(); i++) {
                int basketItemId = Integer.parseInt(updatedBasketItemIds.get(i));
                int quantity = Integer.parseInt(updatedAllQuantity.get(i));
                if (quantity == 0) {
                    deletePreparedStatement.setInt(1, basketItemId);
                    deletePreparedStatement.executeUpdate();
                } else {
                    updatePreparedStatement.setInt(1, quantity);
                    updatePreparedStatement.setInt(2, basketItemId);

                    updatePreparedStatement.executeUpdate();
                }

            }
        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (updatePreparedStatement != null) {
                    updatePreparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                updatePreparedStatement = null;
            }
            try {
                if (deletePreparedStatement != null) {
                    deletePreparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                deletePreparedStatement = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
    }

    /*
     * getBasketItems has successfully created
     */
    public ArrayList<BasketItem> getBasketItems(int basketId) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        ArrayList<BasketItem> basketItems = new ArrayList<BasketItem>();
        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(SQL_GET_ALL_BASKET_ITEMS);
            preparedStatement.setInt(1, basketId);
            rs = preparedStatement.executeQuery();
            BasketItem basketItem = null;
            while(rs.next()) {
                basketItem = new BasketItem();
                basketItem.setId(rs.getInt("basket_item_id")); // 第6回で追加
                basketItem.setName(rs.getString("name"));
                basketItem.setPrice(rs.getInt("price"));
                basketItem.setQuantity(rs.getInt("quantity")); // 第6回でデフォルト1からResultSetの値に変更
                basketItems.add(basketItem);
            }

        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                preparedStatement = null;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                rs = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
                conn = null;
            }
        }
        return basketItems;
    }

    private Connection getConnection() throws SQLException, NamingException {
        Connection conn;
        Context c = new InitialContext();
        DataSource ds = (DataSource) c.lookup("java:comp/env/jdbc/imoshop");
        conn = ds.getConnection();
        return conn;
    }
}
